<?php

class AdminController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        if (!Csrf::isTokenValid()) {
          //redirect to forbidden and exit
          header('HTTP/1.0 403 Forbidden', true, 403);
          exit();
        }
        $this->user=Auth::isAuthenticated();
    }

    /**
     * Handles what happens when user moves to URL/index/index - or - as this is the default controller, also
     * when user moves to /index or enter your application at base level
     */
    public function index()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $this->View->render('admin/index', array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'vehicleid' => $vehicleid,
            'classes' => HmsModel::getAllVehicleClasses()
        ));
    }

    public function configuration()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Configuration_View"]["granted"]){
           $this->View->renderWithoutHeaderAndFooter('admin/config_dev', array(
               'classes' => HmsModel::getAllVehicleClasses(),
               'vehicleid' => $vehicleid,
               'intervals' => HmsModel::getInspectionIntervals($vehicleid),
               'rooturl' => UtilityModel::getRootURL(),
               'repairschemes' => json_encode(HmsModel::getRepairSchemeList($vehicleid),JSON_PRETTY_PRINT),
               'formulas' => json_encode(AdminModel::getFormulas($vehicleid,-1,false),JSON_PRETTY_PRINT)
           ));
        }
    }

    public function reference()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Reference Admin_View"]["granted"])$files[]='admin/reference';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'years' => array_reverse(UtilityModel::getDatesFromRange('1999-01-01'))
        ),'header_view');
    }

    public function repairSchemes()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Repair Schemes_View"]["granted"])$files[]='admin/repairschemes';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'schemes' => AdminModel::getRepairSchemes($vehicleid)
        ),'header_view');
    }

    public function rcm()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_RCM Database_View"]["granted"])$files[]='admin/rcm';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'versions' => AdminModel::getRCMVersions($vehicleid,true),
            'latestversion' => 0
        ),'header_view');
    }

    public function formulas()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Formulas_View"]["granted"])$files[]='admin/formulas';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'formulas' => AdminModel::getFormulas($vehicleid)
        ),'header_view');


    }

    public function roles()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Roles_View"]["granted"])$files[]='admin/roles';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'vehicles' => AdminModel::getAllVehicles(),
            'roles' => AdminModel::getAllRoles(),
            'units' => HmsModel::getHoldingUnits($vehicleid)
        ),'header_view');

    }

    public function users()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('admin/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_Users_View"]["granted"])$files[]='admin/users';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => $permissions,
            'classes' => HmsModel::getAllVehicleClasses(),
            'vehicleid' => $vehicleid,
            'vehicles' => AdminModel::getAllVehicles(),
            'roles' => AdminModel::getRoleList(),
            'users' => AdminModel::getUsers()
        ),'header_view');

    }


    public function getView(){

        $vehicleid=Session::get('vehicleid');
        $schedule=Validate::int(Request::post('scheduleid'));
        $type=Validate::string(Request::post('type'));
        $view=Validate::string(Request::post('view'));
        $version=Validate::int(Request::post('version'));
        $results=AdminModel::getView($vehicleid,$schedule,$type,$view,$version);
        // output json results
        echo $results;
    }

    public function getRCMInfo(){
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $results=AdminModel::getRCMInfo($vehicleid,$version);
        echo json_encode($results);
    }

    public function getSSIDescriptions()
    {
        $vehicleid=Session::get('vehicleid');
        $results=AdminModel::getSSIDescriptions($vehicleid);
        echo json_encode($results);
    }

    public function getRCMVersions()
    {
        $vehicleid=Session::get('vehicleid');
        $results=AdminModel::getRCMVersions($vehicleid);
        echo json_encode($results);
    }

    public function getRCMRecord()
    {
        $rcmid=Validate::int(Request::post('rcmid'));
        $results=AdminModel::getRCMRecord($rcmid);
        echo $results;
    }

    public function getRCMByFilter()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $filtermap=Validate::int(Request::post('filtermap'));
        $results=AdminModel::getRCMBYFilter($vehicleid,$version,$filtermap);
        echo $results;
    }

    public function openRCMRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::openRCMRecord($id);
        echo $results;
    }

    public function saveRCMRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $id=Validate::int(Request::post('id'));
        $reference=Validate::string(Request::post('reference'));
        $description=Validate::string(Request::post('description'));
        $data=Validate::json(Request::post('data'));
        $selected=AdminModel::saveRCMRecord($vehicleid,$version,$id,$reference,$description,$data);
        $results=AdminModel::getRCMBYFilter($vehicleid,$version,0);
        echo '{"selected":'.$selected.',"results":'.$results.'}';
    }

    public function deleteRCMRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $id=Validate::int(Request::post('id'));
        $version=Validate::int(Request::post('version'));
        AdminModel::deleteRCMRecord($id);
        $results=AdminModel::getRCMBYFilter($vehicleid,$version,0);
        echo $results;
    }

    public function createRCMVersion()
    {
        $vehicleid=Session::get('vehicleid');
        $copyversion=Validate::int(Request::post('copyversion'));
        $forecastusage=Validate::int(Request::post('forecastUsage'));
        $nomrefstartdate=Validate::date(Request::post('nomRefStartDate'));
        $results=AdminModel::createRCMVersion($vehicleid,$copyversion,$forecastusage,$nomrefstartdate);
        echo $results;
    }

    public function lockRCMVersion()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $results=AdminModel::lockRCMVersion($vehicleid,$version);
        echo $results;
    }

    public function editInspectionVersion()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $description=Validate::string(Request::post('description'));
        $status=Validate::int(Request::post('status'));
        $results=AdminModel::editInspectionVersion($vehicleid,$version,$description,$status);
        return $results;
    }

    public function getInspectionVersion()
    {
        $vehicleid=Session::get('vehicleid');
        $version=Validate::int(Request::post('version'));
        $results=AdminModel::getInspectionVersion($vehicleid,$version);
        echo json_encode($results);

    }

    public function createInspectionVersion()
    {
        $vehicleid=Session::get('vehicleid');
        $description=Validate::string(Request::post('description'));
        $rcmversion=Validate::int(Request::post('rcmversion'));
        $results=AdminModel::createInspectionVersion($vehicleid,$description,$rcmversion);
        echo '{"newversion":'.$results."}";
    }
    public function saveView()
    {
        $vehicleid=Session::get('vehicleid');
        $scheduleid=Validate::int(Request::post('scheduleid'));
        $view=Validate::string(Request::post('view'));
        $image=Validate::string(Request::post('image'));
        $metriccount=Validate::int(Request::post('metriccount'));
        $pods=Validate::json(Request::post('pods'));
        $version=Validate::int(Request::post('version'));
        $results=AdminModel::saveView($vehicleid,$scheduleid,$view,$image,$metriccount,$pods,$version);
        echo $results;
    }
    public function searchVehicleInfo()
    {
        $vrn=Validate::string(Request::post('vrn'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/vehicleinforesults', array(
            'results' => HmsModel::getVehicleInfoResults($vrn))
        );
    }

    public function getVehicleInfoRecord()
    {
        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/vehicleinforecord', array(
            'results' => HmsModel::getVehicleInfoRecord($id))
        );
    }

    public function deleteVehicleInfoRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteVehicleInfoRecord($id);
    }

    public function saveVehicleInfoRecord()
    {
        $birthcert=Validate::string(Request::post('birthcert'));
        $borndate=Validate::date(Request::post('borndate'));
        $vrn=Validate::string(Request::post('vrn'));
        $buildstandard=Validate::string(Request::post('buildstandard'));
        $vehiclerole=Validate::string(Request::post('vehiclerole'));
        $recordid=Validate::int(Request::post('recordid'));
        AdminModel::saveVehicleInfoRecord($birthcert,$borndate,$vrn,$buildstandard,$vehiclerole,$recordid);
    }

    public function searchReferenceMaterial()
    {
        $vrn=Validate::string(Request::post('vrn'));
        $vidno=Validate::string(Request::post('vidno'));
        $general=Validate::string(Request::post('general'));
        $year=Validate::string(Request::post('year'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/referencematerialresults', array(
            'results' => HmsModel::getReferenceMaterialResults($vrn,$vidno,$general,$year))
        );
    }

    public function getReferenceMaterialRecord()
    {

        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/referencematerialrecord', array(
            'years' => array_reverse(UtilityModel::getDatesFromRange('1999-01-01')),
            'results' => HmsModel::getReferenceMaterialRecord($id)
        ));
    }

    public function deleteReferenceMaterialRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteReferenceMaterialRecord($id);
    }

    public function saveReferenceMaterialRecord()
    {
        $document=Validate::string(Request::post('document'));
        $title=Validate::string(Request::post('title'));
        $vrn=Validate::string(Request::post('vrn'));
        $vidno=Validate::string(Request::post('vidno'));
        $reference=Validate::string(Request::post('reference'));
        $issuedate=Validate::string(Request::post('year'));
        $organisation=Validate::string(Request::post('organisationname'));
        $recordid=Validate::int(Request::post('recordid'));
        $results=AdminModel::saveReferenceMaterialRecord($document,$title,$vrn,$vidno,$reference,$issuedate,$organisation,$recordid);
    }

    public function searchMinutes()
    {
        $general=Validate::string(Request::post('general'));
        $year=Validate::string(Request::post('year'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/minutesresults', array(
            'results' => HmsModel::getMinutesResults($general,$year))
        );
    }

    public function getMinutesRecord()
    {
        $id=Validate::int(Request::post('id'));
        $this->View->renderWithoutHeaderAndFooter('admin/ajax/minutesrecord', array(
            'years' => array_reverse(UtilityModel::getDatesFromRange('1999-01-01')),
            'results' => HmsModel::getMinutesRecord($id)
        ));
    }

    public function deleteMinutesRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteMinutesRecord($id);
    }

    public function saveMinutesRecord()
    {
        $document=Validate::string(Request::post('document'));
        $title=Validate::string(Request::post('title'));
        $reference=Validate::string(Request::post('reference'));
        $issuedate=Validate::date(Request::post('issuedate'));;
        $organisation=Validate::string(Request::post('organisationname'));
        $recordid=Validate::int(Request::post('recordid'));
        $results=AdminModel::saveMinutesRecord($document,$title,$reference,$issuedate,$organisation,$recordid);
        echo $results;
    }

    public function openRepairSchemeRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::openRepairSchemeRecord($id);
        echo json_encode($results);
    }

    public function saveRepairSchemeRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $id=Validate::int(Request::post('id'));
        $reference=Validate::string(Request::post('reference'));
        $title=Validate::string(Request::post('title'));
        $data=Validate::string(Request::post('data'));
        $description=Validate::string(Request::post('description'));
        $vrn=Validate::string(Request::post('vrn'));
        $type=Validate::string(Request::post('type'));
        $results=AdminModel::saveRepairSchemeRecord($id,$vehicleid,$title,$reference,$data,$description,$vrn,$type);
        echo json_encode($results);
    }

    public function deleteRepairSchemeRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteRepairSchemeRecord($id,$vehicleid);
        echo json_encode($results);
    }

    public function getRole(){
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::getRole($id);
        echo json_encode($results);
    }

    public function saveRole(){
        $id=Validate::int(Request::post('id'));
        $role=Validate::string(Request::post('role'));
        $permissions=Validate::json(Request::post('permissions'));
        $results=AdminModel::saveRole($id,$role,$permissions);
        echo json_encode($results);
    }

    public function deleteRole()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteRole($id);
        echo json_encode($results);
    }

    public function sendUserEmail()
    {
       $toArray=array(Validate::string(Request::post('to')));
       $subject=Validate::string(Request::post('subject'));
       $message=Validate::string(Request::post('message'));
       $results=UtilityModel::socket_mail($toArray, $subject, $message);
       echo json_encode($results);
    }

    public function registerUserName()
    {
        $proposedusername=Validate::string(Request::post('proposedusername'));
        $results=AdminModel::registerUserName($proposedusername);
        echo json_encode($results);
    }

    public function openUserRecord()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::openUserRecord($id);
        echo json_encode($results);
    }

    public function saveUser()
    {
       $id=Validate::int(Request::post('id'));
       $role=Validate::int(Request::post('role'));
       $uservehicles=array();
       foreach(Request::post('uservehicles') as $uservehicle){
          $uservehicles[]=(int)Validate::int($uservehicle);
       }
       $encodeduservehicles=json_encode($uservehicles);
       $results=AdminModel::saveUser($id,$role,$encodeduservehicles);
       echo json_encode($results);
    }

    public function deleteUser()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::deleteUser($id);
        echo json_encode($results);
    }

    public function getFormulaById()
    {
        $id=Validate::int(Request::post('id'));
        $results=AdminModel::getFormulaById($id);
        echo json_encode($results);
    }

    public function saveFormula()
    {
        $id=Validate::int(Request::post('id'));
        $vehicleid=Validate::int(Request::post('vehicleid'));
        $formula=Validate::string(Request::post('formula'));
        $description=Validate::string(Request::post('description'));
        $usedon=Validate::string(Request::post('usedon'));

        $results=AdminModel::saveFormula($id,$vehicleid,$formula,$description,$usedon);
        echo json_encode($results);
    }

    public function deleteFormula()
    {
        $id=Validate::int(Request::post('id'));
        $vehicleid=Validate::int(Request::post('vehicleid'));
        $results=AdminModel::deleteFomula($id,$vehicleid);
        echo json_encode($results);
    }

    private function getRootURL()
    {
        $domain = $_SERVER['HTTP_HOST'];
        $protocol_array = explode('/',$_SERVER['SERVER_PROTOCOL']);
        $protocol = strtolower($protocol_array[0]);
        $path = str_replace( basename($_SERVER['SCRIPT_FILENAME']), '', $_SERVER['PHP_SELF'] );
        $url = $protocol.'://'.$domain.$path;
        return $url;
    }

    private function getCurrentWorkingDirectory()
    {
        return str_replace('\\', '/', getcwd());
    }

    public function getFileList()
    {
        $directory=Validate::string(Request::post('directory'));
        $results=json_encode(UtilityModel::getFileList($directory));
        echo $results;
    }

    public function addFolder()
    {
        $directory=Validate::string(Request::post('directory'));
        $results=json_encode(UtilityModel::addFolder($directory));
        echo $results;
    }

    public function deleteFile()
    {
        $directory=Validate::string(Request::post('directory'));
        $files=Validate::string(Request::post('files'));
        $results=json_encode(UtilityModel::deleteFile($directory,$files));
        echo $results;
    }

    public function pasteFile()
    {
        $mode=Validate::string(Request::post('mode'));
        $from=Validate::string(Request::post('from'));
        $to=Validate::string(Request::post('to'));
        $files=Validate::string(Request::post('files'));
        $results=json_encode(UtilityModel::pasteFile($mode,$from,$to,$files));
        echo $results;
    }

    public function uploadFiles()
    {
        if(isset($_FILES['upl']) && $_FILES['upl']['error'] == 0){
           $directory=Validate::string(Request::post('directory'));
           $files=$_FILES;
           $results=UtilityModel::uploadFiles($files,$directory);
           echo $results;
        }
    }
}


